"use client";
// Start import
import { useState, useEffect } from "react";
import { Button } from "../../../../components/ui/button";
import { Label } from "../../../../components/ui/label";
import { Input } from "../../../../components/ui/input";
import { Textarea } from "../../../../components/ui/textarea";
import Select from "react-select";
import instance from "../../../../lib/axiosInstance";
import { useForm, Controller } from "react-hook-form";
import { yupResolver } from "@hookform/resolvers/yup";
import * as yup from "yup";
import { Loader2 } from "lucide-react";
import { useCrudOperation } from "../../../context/CrudOperationContect";
import { toast } from "sonner";
import { DialogClose } from "../../../../components/ui/dialog";

// End import

// Schéma de validation YUP
const schema = yup.object().shape({
  name: yup.string().required("Le type de frais est obligatoire"),
  description: yup.string().nullable(),
});

// Export
export const Form = ({ closeModal, rowData }) => {
  
  // Utilisation du contexte pour accéder aux données et fonctions
  const { addOperation,updateOperation } = useCrudOperation(); 
  
  // Define react-hook-form
  const {
    register,
    handleSubmit,
    formState: { errors, isSubmitting },
  } = useForm({
    resolver: yupResolver(schema),
    defaultValues: {
      description: rowData?.description,
      name: rowData?.name,
    }
  });
  
  // Set method to add
  const onSubmit = async (data) => {
    try {
      // Formatage des données pour l'API
      const formattedData = {
        name: data.name,
        description: data.description,
      };

      // console.log(data);
      const query = await instance.post("fee-types", formattedData);
      addOperation(query.data.response);
      toast.success("Succès", {
        description: query.data.message,
        position: "top-center",
        style: {
          backgroundColor: "#4CAF50",
          color: "white",
        },
      });
      
      // Ferme le modal après soumission réussie
      closeModal();
    } catch (error) {
      // Gestion des erreurs de validation
      const errors = error.data?.response;
      if (errors) {
        Object.entries(errors).map(([field, messages]) => {
          toast.error("Erreur", {
            description: messages,
            position: "top-center",
            style: {
              backgroundColor: "#E11409FF",
              color: "white",
            },
          });
        });
      }
    }
  };

   // Set method to update
   const onUpdate = async (data) => {
    try {
      // Formatage des données pour l'API
      const formattedData = {
        name: data.name,
        description: data.description,
      };

      // console.log(data);
      // console.log(rowData?.id)

      const query = await instance.put("fee-types/"+ rowData?.id, formattedData);
      updateOperation(query.data.response);
      toast.success("Succès", {
        description: query.data.message,
        position: "top-center",
        style: {
          backgroundColor: "#4CAF50",
          color: "white",
        },
      });

      // Ferme le modal après soumission réussie
      closeModal();
    } catch (error) {
      // Gestion des erreurs de validation
      const errors = error.data?.response;
      if (errors) {
        Object.entries(errors).map(([field, messages]) => {
          toast.error("Erreur", {
            description: messages,
            position: "top-center",
            style: {
              backgroundColor: "#E11409FF",
              color: "white",
            },
          });
        });
      }
    }
  };
  
  // Return
  return (
    <form onSubmit={ rowData?.id ? handleSubmit(onUpdate): handleSubmit(onSubmit)}>
      <div className="">
        <Label htmlFor="name" className="text-right mb-2">
          Type de frais <span className="text-red-500">*</span>
        </Label>
        <Input
          id="name"
          {...register("name")}
          placeholder="Type de frais..."
          className="w-full"
        />
        <span className="text-red-500 text-sm">{errors.name?.message}</span>
      </div>

      <div className="py-4">
        <Label htmlFor="description" className="text-right mb-2">
          Description
        </Label>
        <Textarea 
          id="description" 
          {...register("description")} 
          placeholder="Description..."
          className="w-full"
        />
        <span className="text-red-500 text-sm">{errors.description?.message}</span>
      </div>
      
      <div className="flex justify-center items-center mt-4 gap-2">
        <DialogClose asChild>
          <Button variant="destructive" className="h-12">
            Annuler
          </Button>
        </DialogClose>
        <Button type="submit" disabled={isSubmitting} className="h-12">
          {isSubmitting ? (
            <Loader2 className="animate-spin w-5 h-5 mr-2" />
          ) : (
            "Enregistrer"
          )}
        </Button>
      </div>
    </form>
  );
};