"use client";

// Start import
import { Checkbox } from "../../../../components/ui/checkbox";
import { DataTableColumnHeader } from "../../../../components/datatable/data-table-column-header";
import DeleteDialog from "./delete-dialog";

import { FormDialog } from "./form-dialog";
import { Form } from "./form";
import { formatCurrency } from "../../../../lib/utils";
import { format } from "date-fns";
import { fr } from "date-fns/locale";
import { usePathname } from "next/navigation";
import Link from "next/link";


// End import

export const columns = [
  {
    id: "select",
    header: ({ table }) => (
      <Checkbox
        checked={
          table.getIsAllPageRowsSelected() ||
          (table.getIsSomePageRowsSelected() && "indeterminate")
        }
        onCheckedChange={(value) => table.toggleAllPageRowsSelected(!!value)}
        aria-label="Select all"
      />
    ),
    cell: ({ row }) => (
      <Checkbox
        checked={row.getIsSelected()}
        onCheckedChange={(value) => row.toggleSelected(!!value)}
        aria-label="Select row"
      />
    ),
    enableSorting: false,
    enableHiding: false,
  },
  {
    accessorKey: "amount",
    header: ({ column }) => (
      <DataTableColumnHeader column={column} title="MONTANT" />
    ),
    cell: ({ row }) => {
      const amount = row.getValue("amount");
      const pathname = usePathname();
      const id = row.original.id;


      return (
        <Link href={`${pathname}/${id}/paymentsschedule`} className="text-start font-medium text-indigo-500">
          {formatCurrency(amount)}
        </Link>
      );
    },
  },
  {
    accessorKey: "terms",
    header: ({ column }) => (
      <DataTableColumnHeader column={column} title="NOMBRE DE MODALITÉ" />
    ),
  },
  {
    accessorKey: "due_date",
    header: ({ column }) => (
      <DataTableColumnHeader column={column} title="DATE LIMITE DE PAIEMENT" />
    ),
    cell: ({ row }) => {
      const date = row.getValue("due_date");
      return (
        <div className="text-start text-red-700 font-bold">
          {date ? format(new Date(date), "dd MMMM yyyy", { locale: fr }) : "-"}
        </div>
      );
    },
  },
  {
    accessorKey: "level",
    header: ({ column }) => (
      <DataTableColumnHeader column={column} title="NIVEAU" />
    ),
    cell: ({ row }) => {
      const level = row.getValue("level");
      return (
        <div className="text-start font-medium">
          {level.name}
        </div>
      );
    },
  },
  {
    accessorKey: "fee_type",
    header: ({ column }) => (
      <DataTableColumnHeader column={column} title="TYPE DE FRAIS" />
    ),
    cell: ({ row }) => {
      const feetypes = row.getValue("fee_type");
      return (
        <div className="text-start font-medium">
          {feetypes.name}
        </div>
      );
    },
  },
  {
    id: "actions",
    header: "ACTIONS",
    cell: ({ row }) => {
      const rowData = row.original;
      return (
        <div className="flex gap-2">
          <FormDialog mode="edit" triggerLabel="Modifier" triggerIcon="edit">
            <Form rowData={rowData} />
          </FormDialog>
          <DeleteDialog rowID={rowData.id} />
        </div>
      );
    },
  },
];
