"use client";
import React, { useState } from "react"; // Ajout de React
import {
  Dialog,
  DialogTrigger,
  DialogContent,
  DialogHeader,
  DialogTitle,
  DialogDescription,
} from "../../../../components/ui/dialog";
import { Button } from "../../../../components/ui/button";
import { PlusCircleIcon, PencilIcon } from "lucide-react";

export const FormDialog = ({
  mode = "add",
  triggerLabel = "Ajouter",
  triggerIcon = "plus",
  title,
  description,
  children,
}) => {
  // Set modal state
  const [isModalOpen, setIsModalOpen] = useState(false);
  const isEdit = mode === "edit";

  const renderIcon = () => {
    if (triggerIcon === "plus") return <PlusCircleIcon className="ml-2" />;
    if (triggerIcon === "edit") return <PencilIcon className="h-4 w-4 mr-2" />;
    return null;
  };

  // La méthode pour fermer le modal
  const closeModal = () => setIsModalOpen(false);

  return (
    <Dialog open={isModalOpen} onOpenChange={setIsModalOpen}>
      <DialogTrigger asChild>
        {triggerIcon === "plus" ? (
          <Button className="rounded-none h-12" onClick={() => setIsModalOpen(true)}>
            <span>{triggerLabel}</span>
            {renderIcon()}
          </Button>
        ) : (
          <Button
            variant="link"
            className="flex items-center hover:cursor-pointer"
          >
            {renderIcon()}
          </Button>
        )}
      </DialogTrigger>

      <DialogContent>
        <DialogHeader className="border-b border-gray-200 pb-4 mb-2">
          <DialogTitle className="uppercase font-light text-[#dd7b34]">
            {title ||
              (isEdit
                ? "Modifier le frais scolaire"
                : "Ajouter un frais scolaire")}
          </DialogTitle>
          {/* <DialogDescription>
            {description ||
            (isEdit
            ? "Modifie les informations existantes."
            : "Remplis les champs pour ajouter un élément.")}
          </DialogDescription> */}
        </DialogHeader>
        {/* Injection du formulaire enfant avec la fonction de fermeture */}
        {React.cloneElement(children, { closeModal })}
      </DialogContent>
    </Dialog>
  );
};
