import { IoIosSchool } from "react-icons/io";
import { FaLongArrowAltRight } from "react-icons/fa";
import Link from "next/link";

// breadcrumb
const breadcrumb = [
  { label: "Dashboard", href: "/" },
  { label: "Home", href: "/" },
  { label: "Dashboard", href: "/" },
];


export const metadata = {
  title: "Tableau de board - Mon établissement",
};

export default function page() {
  return (
    <div className="container mx-auto">
      <div className="grid grid-cols-4 gap-5">
        <div className="flex flex-col gap-4 border border-[#fb923d] bg-[#fb923d] rounded-xl p-5">
          <div className="flex items-center gap-3">
            <IoIosSchool className="text-4xl text-white" />
            <div className="flex flex-col gap-0">
              <h1 className="text-xl font-semibold text-black">325</h1>
              <span className="text-gray font-bold text-xl">Élèves</span>
            </div>
          </div>
          <hr className="border-[#611c14]" />
          <div>
            <div className="flex flex-row justify-between">
              <span>
                <Link href="dashboard" className="text-white">
                  Consulter la lsite
                </Link>
              </span>
              <Link href="dashboard">
                <FaLongArrowAltRight className="text-xl text-white" />
              </Link>
            </div>
          </div>
        </div>

        <div className="flex flex-col gap-4 border border-[#611c14] rounded-xl p-5">
          <div className="flex items-center gap-3">
            <IoIosSchool className="text-4xl text-[#611c14]" />
            <div className="flex flex-col gap-0">
              <h1 className="text-xl font-semibold text-black">10</h1>
              <span className="text-gray font-bold text-xl">Classe</span>
            </div>
          </div>
          <hr className="border-[#611c14]" />
          <div>
            <div className="flex flex-row justify-between">
              <span>
                <Link href="dashboard">Consulter la lsite</Link>
              </span>
              <Link href="dashboard">
                <FaLongArrowAltRight className="text-xl text-[#032313]" />
              </Link>
            </div>
          </div>
        </div>

        <div className="flex flex-col gap-4 border border-[#fb923d] bg-[#fb923d] rounded-xl p-5">
          <div className="flex items-center gap-3">
            <IoIosSchool className="text-4xl text-white" />
            <div className="flex flex-col gap-0">
              <h1 className="text-xl font-semibold text-black">25</h1>
              <span className="text-gray font-bold text-xl">Matières</span>
            </div>
          </div>
          <hr className="border-[#611c14]" />
          <div>
            <div className="flex flex-row justify-between">
              <span>
                <Link href="dashboard" className="text-white">
                  Consulter la lsite
                </Link>
              </span>
              <Link href="dashboard">
                <FaLongArrowAltRight className="text-xl text-white" />
              </Link>
            </div>
          </div>
        </div>

        <div className="flex flex-col gap-4 border border-[#611c14] rounded-xl p-5">
          <div className="flex items-center gap-3">
            <IoIosSchool className="text-4xl text-[#611c14]" />
            <div className="flex flex-col gap-0">
              <h1 className="text-xl font-semibold text-black">55</h1>
              <span className="text-gray font-bold text-xl">Enseignants</span>
            </div>
          </div>
          <hr className="border-[#611c14]" />
          <div>
            <div className="flex flex-row justify-between">
              <span>
                <Link href="dashboard">Consulter la lsite</Link>
              </span>
              <Link href="dashboard">
                <FaLongArrowAltRight className="text-xl text-[#032313]" />
              </Link>
            </div>
          </div>
        </div>
      </div>
    </div>
  );
}
