"use client";
import { useState } from "react";
import { RiMenuFoldFill } from "react-icons/ri";
import NavBar from "../../components/admin/navBar";
import Header from "../../components/admin/header";
import { AuthProvider } from "../../app/context/AuthContext";

const Layout = ({ children, breadcrumb }) => {
  const [isCollapsed, setIsCollapsed] = useState(false);

  return (
    <AuthProvider>
      <div
        className="grid h-screen grid-cols-12"
      >
        <div
          className={`bg-[#611c14] flex flex-col gap-4 transition-all duration-300 h-screen ${
            isCollapsed ? "col-span-1" : "col-span-2"
          }`}
        >
          <div className="logo bg-white h-16 flex items-center justify-center">
            <div className="flex items-center justify-between gap-2">
              <div
                className={`transition-opacity duration-300 ${
                  isCollapsed ? "opacity-0 w-0" : "opacity-100"
                }`}
              >
                <h1 className="text-2xl">
                  XSEL<span>SCHOOL</span>
                </h1>
              </div>
              <button
                onClick={() => setIsCollapsed(!isCollapsed)}
                className="burger-menu hover:text-[#aedf33] transition-colors duration-200"
              >
                <RiMenuFoldFill
                  className={`text-2xl transform transition-transform duration-200 ${
                    isCollapsed ? "rotate-180" : ""
                  }`}
                />
              </button>
            </div>
          </div>

          <div
            className={`transition-all duration-300 h-[90%] overflow-y-auto flex justify-center ${
              isCollapsed ? "" : "w-full px-5"
            }`}
          >
            <NavBar isCollapsed={isCollapsed} />
          </div>
        </div>

        <div className="col-span-10">
          <Header breadcrumb={breadcrumb} />
          <div className="p-6">
            <main>{children}</main>
          </div>
        </div>
        
      </div>
    </AuthProvider>
  );
};

export default Layout;
