"use client";

// Start import
import { MoreHorizontal, ArrowUpDown } from "lucide-react";
import { Checkbox } from "../../../../components/ui/checkbox";
import { Button } from "../../../../components/ui/button";
import { DataTableColumnHeader } from "../../../../components/datatable/data-table-column-header";
import DeleteDialog from "./delete-dialog";
import {
  DropdownMenu,
  DropdownMenuContent,
  DropdownMenuLabel,
  DropdownMenuTrigger,
} from "../../../../components/ui/dropdown-menu";
import { FormDialog } from "./form-dialog";
import { Form } from "./form";
// End import

export const columns = [
  {
    id: "select",
    header: ({ table }) => (
      <Checkbox
        checked={
          table.getIsAllPageRowsSelected() ||
          (table.getIsSomePageRowsSelected() && "indeterminate")
        }
        onCheckedChange={(value) => table.toggleAllPageRowsSelected(!!value)}
        aria-label="Select all"
      />
    ),
    cell: ({ row }) => (
      <Checkbox
        checked={row.getIsSelected()}
        onCheckedChange={(value) => row.toggleSelected(!!value)}
        aria-label="Select row"
      />
    ),
    enableSorting: false,
    enableHiding: false,
  },
  {
    accessorKey: "first_name",
    header: ({ column }) => (
      <DataTableColumnHeader column={column} title="NON" />
    ),
  },
  {
    accessorKey: "last_name",
    header: ({ column }) => (
      <DataTableColumnHeader column={column} title="DESCRIPTION" />
    ),
  },
  {
    id: "actions",
    header: "ACTIONS",
    cell: ({ row }) => {
      const rowData = row.original;
      return (
        <div className="flex flex-row gap-2">
          <DeleteDialog rowID={rowData.id} />
          <FormDialog mode="edit" triggerLabel="Modifier" triggerIcon="edit">
            <Form rowData={rowData} />
          </FormDialog>
        </div>
      );
    },
  },
];
