"use client";

// Start import
import { DataTableColumnHeader } from "../../../../components/datatable/data-table-column-header";
import DeleteDialog from "./delete-dialog";
import { Checkbox } from "../../../../components/ui/checkbox";
import { FormDialog } from "./form-dialog";
import { Form } from "./form";
// End import

// Définition des colonnes pour le tableau des éducateurs
export const columns = [
  // Colonne de sélection avec checkbox
  {
    id: "select",
    header: ({ table }) => (
      <Checkbox
        checked={
          table.getIsAllPageRowsSelected() ||
          (table.getIsSomePageRowsSelected() && "indeterminate")
        }
        onCheckedChange={(value) => table.toggleAllPageRowsSelected(!!value)}
        aria-label="Select all"
      />
    ),
    cell: ({ row }) => (
      <Checkbox
        checked={row.getIsSelected()}
        onCheckedChange={(value) => row.toggleSelected(!!value)}
        aria-label="Select row"
      />
    ),
    enableSorting: false,
    enableHiding: false,
  },
  // Colonne pour le prénom de l'éducateur
  {
    accessorKey: "first_name",
    header: ({ column }) => (
      <DataTableColumnHeader column={column} title="PRÉNOM(S)" />
    ),
    cell: ({ row }) => {
      return (
          <span className="text-start font-light text-red-700">
            {row.original?.first_name}
          </span>
      );
    },
  },
  // Colonne pour le nom de l'éducateur
  {
    accessorKey: "last_name",
    header: ({ column }) => (
      <DataTableColumnHeader column={column} title="NOM" />
    ),
    cell: ({ row }) => {
      return (
          <span className="text-start font-light text-blue-700">
            {row.original?.last_name}
          </span>
      );
    },
    
  },
  // Colonne pour l'email de l'éducateur
  {
    accessorKey: "email",
    header: ({ column }) => (
      <DataTableColumnHeader column={column} title="EMAIL" />
    ),
  },
  // Colonne pour les contacts de l'éducateur
  {
    accessorKey: "phone",
    header: ({ column }) => (
      <DataTableColumnHeader column={column} title="CONTACTS" />
    ),
  },
  // Colonne pour les classes assignées à l'éducateur
  {
    accessorKey: "classrooms",
    header: ({ column }) => (
      <DataTableColumnHeader column={column} title="CLASSE" />
    ),
    cell: ({ row }) => {
      const classrooms = row.getValue("classrooms");
      return (
        <div className="text-start font-medium">
          <ul className="text-start font-medium space-y-1 flex flex-row gap-2">
            {classrooms?.map((classroom) => (
              <li key={classroom.id} className="text-blue-600">{classroom.name},</li>
            ))}
          </ul>
        </div>
      );
    },
  },
  // Colonne des actions (modification et suppression)
  {
    id: "actions",
    header: "ACTIONS",
    cell: ({ row }) => {
      const rowData = row.original;
      return (
        <div className="flex gap-2">
          <FormDialog mode="edit" triggerLabel="Modifier" triggerIcon="edit">
            <Form rowData={rowData} />
          </FormDialog>
          <DeleteDialog rowID={rowData.id} />
        </div>
      );
    },
  },
];
