/**
 * Component for displaying the list of educators in a data table format
 * This component is part of the admin personnel management section
 */
import * as React from "react";
import { columns } from "./columns";
import { DataTable } from "./data-table";
import { useCrudOperation } from "../../../context/CrudOperationContect";

export default function List() {
  // Get the list of educators data from the CRUD operation context
  const { dataList } = useCrudOperation();
  
  return (
    // Container with styling for the data table
    <div className="container mx-auto py-10 shadow-2xl p-10 border-1 border-[#611c14]">
      {/* Render the data table with columns configuration and educators data */}
      <DataTable columns={columns} data={dataList} />
    </div>
  );
}
