"use client";

// Import du contexte pour les opérations CRUD
import { CrudOperationProvider } from "../../../context/CrudOperationContect";
// Import du composant List qui affiche la liste des éducateurs
import List from "./list"

/**
 * Page principale des éducateurs
 * Cette page utilise le CrudOperationProvider pour gérer les opérations CRUD
 * sur les éducateurs et affiche la liste des éducateurs via le composant List
 */
export default function Page() {
  return (
    // Le CrudOperationProvider fournit le contexte pour les opérations CRUD
    // avec l'endpoint "educators" spécifié
    <CrudOperationProvider endpoint="educators">
      {/* Composant List qui affiche la liste des éducateurs */}
      <List />
    </CrudOperationProvider>
  );
}