import { useState } from "react";
import { Trash } from "lucide-react";
import {
  Dialog,
  DialogTrigger,
  DialogContent,
  DialogHeader,
  DialogTitle,
  DialogDescription,
  DialogFooter,
  DialogClose,
} from "../../../../components/ui/dialog";
import { Button } from "../../../../components/ui/button";
import instance from "../../../../lib/axiosInstance";
import { toast } from "sonner";
import { useCrudOperation } from "../../../context/CrudOperationContect";

export default function DeleteDialog({ rowID }) {
  const [isDeleting, setIsDeleting] = useState(false);
  const [isModalOpen, setIsModalOpen] = useState(false);
  const { deleteOperation } = useCrudOperation();

  const handleDelete = async () => {
    setIsDeleting(true);
    try {
      const query = await instance.delete("schools/resources/" + rowID);
      deleteOperation(rowID);
      toast.success("Succès", {
        description: query.data.message,
        position: "top-center",
        style: {
          backgroundColor: "#4CAF50",
          color: "white",
        },
      });
      // Ferme le modal après soumission réussie
      setIsModalOpen(false);
      setIsDeleting(true);

    } catch (error) {
      toast.success("Oops!", {
        description: error.data.message,
        position: "top-center",
        style: {
          backgroundColor: "#E11409FF",
          color: "white",
        },
      });
      setIsDeleting(true);

    }
  };

  return (
    <Dialog open={isModalOpen} onOpenChange={setIsModalOpen}>
      <DialogTrigger asChild>
        <Button variant="link" className="hover:cursor-pointer">
          <Trash className="text-red-600" />
        </Button>
      </DialogTrigger>
      <DialogContent>
        <DialogHeader>
          <DialogTitle>Confirmation de suppression</DialogTitle>
          <DialogDescription>
            Êtes-vous sûr de vouloir supprimer ce secteur d'activité? Cette
            action est irréversible.
          </DialogDescription>
        </DialogHeader>
        <DialogFooter className="mt-4">
          <DialogClose asChild>
            <Button variant="outline">Annuler</Button>
          </DialogClose>
          <Button
            variant="destructive"
            onClick={handleDelete}
            disabled={isDeleting}
          >
            {isDeleting ? "Suppression..." : "Supprimer"}
          </Button>
        </DialogFooter>
      </DialogContent>
    </Dialog>
  );
}
