"use client";
// Start import
import { Button } from "../../../../components/ui/button";
import { Label } from "../../../../components/ui/label";
import { Input } from "../../../../components/ui/input";
import { DialogClose } from "../../../../components/ui/dialog";
import instance from "../../../../lib/axiosInstance";
import { useForm } from "react-hook-form";
import { yupResolver } from "@hookform/resolvers/yup";
import * as yup from "yup";
import { Loader2 } from "lucide-react";
import { useCrudOperation } from "../../../context/CrudOperationContect";
import { toast } from "sonner";

// End import

// Schéma de validation YUP
const schema = yup.object().shape({
  first_name: yup.string().required("Le prénom est obligatoire"),
  last_name: yup.string().required("Le nom est obligatoire"),
  email: yup.string().required("L'email est obligatoire").email("Format d'email invalide"),
  phone: yup.string().required("Le numéro de téléphone est obligatoire"),
});

// Export
export const Form = ({ closeModal, rowData }) => {
  // Utilisation du contexte pour accéder aux données et fonctions
  const { addOperation, updateOperation } = useCrudOperation();

  // Define react-hook-form
  const {
    register,
    handleSubmit,
    formState: { errors, isSubmitting },
  } = useForm({
    resolver: yupResolver(schema),
    defaultValues: {
      first_name: rowData?.first_name,
      last_name: rowData?.last_name,
      email: rowData?.email,
      phone: rowData?.phone,
    },
  });

  // Set method to add
  const onSubmit = async (data) => {
    try {
      // Formatage des données pour l'API
      const formattedData = {
        first_name: data.first_name,
        last_name: data.last_name,
        email: data.email,
        phone: data.phone,
      };

      // console.log(data);
      const query = await instance.post("schools/resources", formattedData);
      addOperation(query.data.response);
      toast.success("Succès", {
        description: query.data.message,
        position: "top-center",
        style: {
          backgroundColor: "#4CAF50",
          color: "white",
        },
      });

      // Ferme le modal après soumission réussie
      closeModal();
    } catch (error) {
      toast.error("Erreur", {
        // Correction de toast.success en toast.error
        description: error.response?.data?.message,
        position: "top-center",
        style: {
          backgroundColor: "#E11409FF",
          color: "white",
        },
      });
    }
  };

   // Set method to update
   const onUpdate = async (data) => {
    try {
      // Formatage des données pour l'API
      const formattedData = {
        first_name: data.first_name,
        last_name: data.last_name,
        email: data.email,
        phone: data.phone,
      };

      // console.log(data);
      console.log(rowData?.id)

      const query = await instance.put("schools/resources/"+ rowData?.id, formattedData);

      updateOperation(query.data.response);

      toast.success("Succès", {
        description: query.data.message,
        position: "top-center",
        style: {
          backgroundColor: "#4CAF50",
          color: "white",
        },
      });

      // Ferme le modal après soumission réussie
      closeModal();
    } catch (error) {
      toast.error("Erreur", {
        // Correction de toast.success en toast.error
        description: error.response?.data?.message || "Une erreur est survenue",
        position: "top-center",
        style: {
          backgroundColor: "#E11409FF",
          color: "white",
        },
      });
    }
  };

  // Return
  return (
    <form onSubmit={ rowData?.id ? handleSubmit(onUpdate): handleSubmit(onSubmit)}>
      <div className="flex gap-2">
        <div className="">
          <Label htmlFor="first_name" className="text-right mb-2">
            Prénom(s) <span className="text-red-500">*</span>
          </Label>
          <Input
            id="first_name"
            {...register("first_name")}
            placeholder="Prénom(s)..."
          />
          <span className="text-red-500 text-sm">
            {errors.first_name?.message}
          </span>
        </div>

        <div className="">
          <Label htmlFor="last_name" className="text-right mb-2">
            Nom <span className="text-red-500">*</span>
          </Label>
          <Input
            id="last_name"
            {...register("last_name")}
            placeholder="Nom..."
          />
          <span className="text-red-500 text-sm">
            {errors.last_name?.message}
          </span>
        </div>
      </div>

      <div className="flex gap-2 py-4">
        <div className="">
          <Label htmlFor="email" className="text-right mb-2">
            Email <span className="text-red-500">*</span>
          </Label>
          <Input
            id="email"
            type="email"
            {...register("email")}
            placeholder="Email..."
          />
          <span className="text-red-500 text-sm">{errors.email?.message}</span>
        </div>

        <div className="">
          <Label htmlFor="phone" className="text-right mb-2">
            Contact <span className="text-red-500">*</span>
          </Label>
          <Input
            id="phone"
            {...register("phone")}
            placeholder="Contact..."
          />
          <span className="text-red-500 text-sm">{errors.phone?.message}</span>
        </div>
      </div>

      <div className="flex justify-center items-center mt-4 gap-2">
        <DialogClose asChild>
          <Button variant="destructive" className="h-12">
            Annuler
          </Button>
        </DialogClose>
        <Button type="submit" disabled={isSubmitting} className="h-12">
          {isSubmitting ? (
            <Loader2 className="animate-spin w-5 h-5 mr-2" />
          ) : (
            "Enregistrer"
          )}
        </Button>
      </div>
    </form>
  );
};
