"use client";
import * as React from "react";
import { columns } from "./columns";
import { DataTable } from "./data-table";
import { useCrudOperation } from "../../../context/CrudOperationContect";

export default function List() {
  // Utilisation du contexte pour accéder aux données et fonctions
  const { dataList} = useCrudOperation();

  return (
    // Conteneur principal avec des styles pour le tableau de données
    // - container: centre le contenu
    // - mx-auto: marge automatique horizontale
    // - py-10: padding vertical
    // - shadow-2xl: ombre portée
    // - p-10: padding général
    // - border-1: bordure fine
    // - border-[#611c14]: couleur de bordure personnalisée
    <div className="container mx-auto py-10 shadow-2xl p-10 border-1 border-[#611c14]">
      {/* 
        Rendu du composant DataTable avec:
        - columns: configuration des colonnes du tableau
        - data: données des enseignants à afficher
      */}
      <DataTable columns={columns} data={dataList} />
    </div>
  );
}