"use client";

// Start import
import { MoreHorizontal, ArrowUpDown } from "lucide-react";
import { Checkbox } from "../../../../components/ui/checkbox";
import { Button } from "../../../../components/ui/button";
import { DataTableColumnHeader } from "../../../../components/datatable/data-table-column-header";
import DeleteDialog from "./delete-dialog";
import {
  DropdownMenu,
  DropdownMenuContent,
  DropdownMenuLabel,
  DropdownMenuTrigger,
} from "../../../../components/ui/dropdown-menu";
import { FormDialog } from "./form-dialog";
import { Form } from "./form";
// End import

// Définition des colonnes pour le tableau des enseignants
export const columns = [
  // Colonne de sélection avec case à cocher
  {
    id: "select",
    header: ({ table }) => (
      <Checkbox
        checked={
          table.getIsAllPageRowsSelected() ||
          (table.getIsSomePageRowsSelected() && "indeterminate")
        }
        onCheckedChange={(value) => table.toggleAllPageRowsSelected(!!value)}
        aria-label="Select all"
      />
    ),
    cell: ({ row }) => (
      <Checkbox
        checked={row.getIsSelected()}
        onCheckedChange={(value) => row.toggleSelected(!!value)}
        aria-label="Select row"
      />
    ),
    enableSorting: false,
    enableHiding: false,
  },
  // Colonne pour le prénom de l'enseignant
  {
    accessorKey: "first_name",
    header: ({ column }) => (
      <DataTableColumnHeader column={column} title="PRÉNOM(S)" />
    ),
    cell: ({ row }) => {
      return (
        <span className="text-start font-light text-red-700">
          {row.original?.first_name}
        </span>
      );
    },
  },
  // Colonne pour le nom de l'enseignant
  {
    accessorKey: "last_name",
    header: ({ column }) => (
      <DataTableColumnHeader column={column} title="NOM" />
    ),
    cell: ({ row }) => {
      return (
        <span className="text-start font-light text-blue-700">
          {row.original?.last_name}
        </span>
      );
    },
  },
  // Colonne pour l'email de l'enseignant
  {
    accessorKey: "email",
    header: ({ column }) => (
      <DataTableColumnHeader column={column} title="EMAIL" />
    ),
  },
  // Colonne pour les contacts de l'enseignant
  {
    accessorKey: "phone",
    header: ({ column }) => (
      <DataTableColumnHeader column={column} title="CONTACTS" />
    ),
  },
  // Colonne pour les matières enseignées
  {
    accessorKey: "subjects",
    header: ({ column }) => (
      <DataTableColumnHeader column={column} title="MATIÈRES" />
    ),
    cell: ({ row }) => {
      const subjects = row.getValue("subjects");
      return (
        <div className="text-start font-medium">
          <ul className="text-start font-medium space-y-1 flex flex-row gap-2 text-red-700">
            {subjects?.map((subject) => (
              <li key={subject.id}>{subject.name},</li>
            ))}
          </ul>
        </div>
      );
    },
  },
  // Colonne des actions (modification et suppression)
  {
    id: "actions",
    header: "ACTIONS",
    cell: ({ row }) => {
      const rowData = row.original;
      return (
        <div className="flex flex-row gap-2">
          <FormDialog mode="edit" triggerLabel="Modifier" triggerIcon="edit">
            <Form rowData={rowData} />
          </FormDialog>
          <DeleteDialog rowID={rowData.id} />
        </div>
      );
    },
  },
];
