"use client";

// Start import
import { MoreHorizontal, ArrowUpDown } from "lucide-react";
import { Checkbox } from "../../../../components/ui/checkbox";
import { Button } from "../../../../components/ui/button";
import { DataTableColumnHeader } from "../../../../components/datatable/data-table-column-header";
import DeleteDialog from "./delete-dialog";
import {
  DropdownMenu,
  DropdownMenuContent,
  DropdownMenuLabel,
  DropdownMenuTrigger,
} from "../../../../components/ui/dropdown-menu";
import { FormDialog } from "./form-dialog";
import { Form } from "./form";
// End import

export const columns = [
  {
    id: "select",
    header: ({ table }) => (
      <Checkbox
        checked={
          table.getIsAllPageRowsSelected() ||
          (table.getIsSomePageRowsSelected() && "indeterminate")
        }
        onCheckedChange={(value) => table.toggleAllPageRowsSelected(!!value)}
        aria-label="Select all"
      />
    ),
    cell: ({ row }) => (
      <Checkbox
        checked={row.getIsSelected()}
        onCheckedChange={(value) => row.toggleSelected(!!value)}
        aria-label="Select row"
      />
    ),
    enableSorting: false,
    enableHiding: false,
  },
  {
    accessorKey: "name",
    header: ({ column }) => (
      <DataTableColumnHeader column={column} title="TYPE" />
    ),
    cell: ({ row }) => {
      const subject = row.getValue("name");
      return (
        <span className="text-start font-medium px-5 py-2 rounded-sm  bg-purple-600 text-white">
          {subject}
        </span>
      );
    },
  },
  {
    accessorKey: "type",
    header: ({ column }) => (
      <DataTableColumnHeader column={column} title="LIBELLÉ" />
    ),
    cell: ({ row }) => {
      const levels = row.getValue("levels");
      return (
        <div className="text-start font-medium">
          <ul className="text-start font-medium space-y-1 flex flex-row gap-2">
            {levels?.map((level) => (
              <li className="text-start font-bold text-sky-600" key={level.id}>
                {level.name},
              </li>
            ))}
          </ul>
        </div>
      );
    },
  },
  {
    accessorKey: "level",
    header: ({ column }) => (
      <DataTableColumnHeader column={column} title="VALEUR MIN" />
    ),
    cell: ({ row }) => {
      const subject = row.getValue("name");
      return (
        <span className="text-start font-medium px-5 py-2 rounded-sm  bg-purple-600 text-white">
          {subject}
        </span>
      );
    },
  },
  {
    accessorKey: "epreuve",
    header: ({ column }) => (
      <DataTableColumnHeader column={column} title="VALEUR MAX" />
    ),
    cell: ({ row }) => {
      const subject = row.getValue("name");
      return (
        <span className="text-start font-medium px-5 py-2 rounded-sm  bg-purple-600 text-white">
          {subject}
        </span>
      );
    },
  },
  {
    id: "actions",
    header: "ACTIONS",
    cell: ({ row }) => {
      const rowData = row.original;
      return (
        <div className="flex gap-2">
          <FormDialog mode="edit" triggerLabel="Modifier" triggerIcon="edit">
            <Form rowData={rowData} />
          </FormDialog>
          <DeleteDialog rowID={rowData.id} />
        </div>
      );
    },
  },
];
