"use client";

// Start import
import { Checkbox } from "../../../../components/ui/checkbox";
import { DataTableColumnHeader } from "../../../../components/datatable/data-table-column-header";
import DeleteDialog from "./delete-dialog";
import { FormDialog } from "./form-dialog";
import { Form } from "./form";
import Link from "next/link";
// End import

export const columns = [
  {
    id: "select",
    header: ({ table }) => (
      <Checkbox
        checked={
          table.getIsAllPageRowsSelected() ||
          (table.getIsSomePageRowsSelected() && "indeterminate")
        }
        onCheckedChange={(value) => table.toggleAllPageRowsSelected(!!value)}
        aria-label="Select all"
      />
    ),
    cell: ({ row }) => (
      <Checkbox
        checked={row.getIsSelected()}
        onCheckedChange={(value) => row.toggleSelected(!!value)}
        aria-label="Select row"
      />
    ),
    enableSorting: false,
    enableHiding: false,
  },
  {
    accessorKey: "name",
    header: ({ column }) => (
      <DataTableColumnHeader column={column} title="CLASSE" />
    ),
    cell: ({ row }) => {
      const classroom = row.getValue("name");
      return (
        <Link href={`classrooms/${row.original.id}`}>
          <span className="text-start font-medium px-5 py-3 bg-purple-600 text-white">
            {classroom}
          </span>
        </Link>
      );
    },
  },
  {
    accessorKey: "description",
    header: ({ column }) => (
      <DataTableColumnHeader column={column} title="DESCRIPTION" />
    ),
  },
  {
    accessorKey: "level",
    header: ({ column }) => (
      <DataTableColumnHeader column={column} title="NIVEAU" />
    ),
    cell: ({ row }) => {
      const level = row.getValue("level");
      return (
        <span className="text-start font-bold text-sky-600">{level.name}</span>
      );
    },
  },
  {
    id: "actions",
    header: "ACTIONS",
    cell: ({ row }) => {
      const rowData = row.original;
      return (
        <div className="flex gap-2">
          <FormDialog mode="edit" triggerLabel="Modifier" triggerIcon="edit">
            <Form rowData={rowData} />
          </FormDialog>
          <DeleteDialog rowID={rowData.id} />
        </div>
      );
    },
  },
];
