"use client";
import React, { useState } from "react"; // Ajout de React
import {
  Dialog,
  DialogTrigger,
  DialogContent,
  DialogHeader,
  DialogTitle,
  DialogDescription,
} from "../../../../components/ui/dialog";
import { Button } from "../../../../components/ui/button";
import { PlusCircleIcon, Pencil } from "lucide-react";

export const FormDialog = ({
  mode = "add",
  triggerLabel = "",
  triggerIcon = "plus",
  title,
  description,
  children,
}) => {
  // Set modal state
  const [isModalOpen, setIsModalOpen] = useState(false);
  const isEdit = mode === "edit";

  // Set icon
  const renderIcon = () => {
    if (triggerIcon === "plus") return <PlusCircleIcon className="ml-2" />;
    if (triggerIcon === "edit") return <Pencil className="h-4 w-4 mr-2" />;
    return null;
  };

  // La méthode pour fermer le modal
  const closeModal = () => setIsModalOpen(false);

  return (
    <Dialog open={isModalOpen} onOpenChange={setIsModalOpen}>
      <DialogTrigger asChild>
        {triggerIcon === "plus" ? (
          <Button className="hover:cursor-pointer rounded-none" onClick={() => setIsModalOpen(true)}>
            <span>{triggerLabel}</span>
            {renderIcon()}
          </Button>
        ) : (
          <Button  size="icon" className="flex items-center hover:cursor-pointer">
            {renderIcon()}
          </Button>
        )}
      </DialogTrigger>

      <DialogContent>
        <DialogHeader>
          <DialogTitle>
            {title || (isEdit ? "Modifier l’élément" : "Ajouter un élément")}
          </DialogTitle>
          <DialogDescription>
            {description ||
              (isEdit
                ? "Modifie les informations existantes."
                : "Remplis les champs pour ajouter un élément.")}
          </DialogDescription>
        </DialogHeader>
        {React.cloneElement(children, { closeModal })}
      </DialogContent>
    </Dialog>
  );
};
