"use client";

// Start import
import { Checkbox } from "../../../../components/ui/checkbox";
import { DataTableColumnHeader } from "../../../../components/datatable/data-table-column-header";
import DeleteDialog from "./delete-dialog";
// import { FormDialog } from "./form-dialog";
// import { Form } from "./form-old";
import {Pencil } from "lucide-react";
import { usePathname } from "next/navigation";
import Link from "next/link";
// End import

export const columns = [
  {
    id: "select",
    header: ({ table }) => (
      <Checkbox
        checked={
          table.getIsAllPageRowsSelected() ||
          (table.getIsSomePageRowsSelected() && "indeterminate")
        }
        onCheckedChange={(value) => table.toggleAllPageRowsSelected(!!value)}
        aria-label="Select all"
      />
    ),
    cell: ({ row }) => (
      <Checkbox
        checked={row.getIsSelected()}
        onCheckedChange={(value) => row.toggleSelected(!!value)}
        aria-label="Select row"
      />
    ),
    enableSorting: false,
    enableHiding: false,
  },
  {
    accessorKey: "name",
    header: ({ column }) => (
      <DataTableColumnHeader column={column} title="NOM DE L'EXAMEN" />
    ),
    cell: ({ row }) => {
      const pathname = usePathname();
      const id = row.original.id;
      return (
          <Link href={`${pathname}/${id}/subjects`}>
          <span className="font-bold uppercase">
            {row.original?.name}
          </span>
          </Link>
      );
    },
  },
  {
    accessorKey: "levels",
    header: ({ column }) => (
      <DataTableColumnHeader column={column} title="NIVEAU" />
    ),
    cell: ({ row }) => {
      return (
          <span className="text-start font-medium px-5 py-3 bg-purple-600 text-white">
            {row.original?.level.name}
          </span>
      );
    },
  },
  {
    accessorKey: "sessions",
    header: ({ column }) => (
      <DataTableColumnHeader column={column} title="NOMBRE DE SESSIONS" />
    ),
  },
  {
    accessorKey: "total_points",
    header: ({ column }) => (
      <DataTableColumnHeader column={column} title="TOTAL DES POINTS" />
    ),
  },
  {
    accessorKey: "pass_points",
    header: ({ column }) => (
      <DataTableColumnHeader column={column} title="POINTS DE RÉUSSITE" />
    ),
  },
  {
    accessorKey: "start_date",
    header: ({ column }) => (
      <DataTableColumnHeader column={column} title="DATE DE DÉBUT" />
    ),
    cell: ({ row }) => {
      const date = row.getValue("start_date");
      if (!date) return null;
      return (
        <div className="whitespace-nowrap">
          <span className="text-start px-5 py-1 text-red-700">
            {new Date(date).toLocaleDateString('fr-FR')}
          </span>
        </div>
      );
    },
  },
  {
    accessorKey: "end_date",
    header: ({ column }) => (
      <DataTableColumnHeader column={column} title="DATE DE FIN" />
    ),
    cell: ({ row }) => {
      const date = row.getValue("end_date");
      if (!date) return null;
      return (
        <div className="whitespace-nowrap">
          <span className="text-start px-5 py-1 text-red-700">
            {new Date(date).toLocaleDateString('fr-FR')}
          </span>
        </div>
      );
    },
  },
  {
    id: "actions",
    header: "ACTIONS",
    cell: ({ row }) => {
      const rowData = row.original;
      const pathname = usePathname();
      // console.log(rowData);
      return (
        <div className="flex gap-2">
            <Link
            href={`${pathname}/form/${rowData.id}`}
            className="flex items-center justify-center text-primary"
          >          <Pencil className="h-4 w-4 mr-2" />
          </Link>
          <DeleteDialog rowID={rowData.id} />
        </div>
      );
    },
  },
];
