"use client";
import * as React from "react";
import { columns } from "./columns";
import { DataTable } from "./data-table";
import { Loader2 } from "lucide-react";
import { useCrudOperation } from "../../../context/CrudOperationContect";

export default function List() {
  // Utilisation du contexte pour accéder aux données et fonctions
  const { dataList, loading } = useCrudOperation();
  return (
    <div className="container mx-auto py-10 shadow-2xl p-10 border-1 border-[#611c14]">
      {loading ? (
        <div className="flex justify-center items-center h-64">
          <Loader2 className="h-8 w-8 animate-spin text-primary" />
        </div>
      ) : (
        <DataTable
          columns={columns}
          data={dataList}
        />
      )}
    </div>
  );
}