import { useState } from "react";
import { Trash } from "lucide-react";
import {
  Dialog,
  DialogTrigger,
  DialogContent,
  DialogHeader,
  DialogTitle,
  DialogDescription,
  DialogFooter,
  DialogClose,
} from "../../../../components/ui/dialog";
import { Button } from "../../../../components/ui/button";
import instance from "../../../../lib/axiosInstance";
import { toast } from "sonner";
import { useCrudOperation } from "../../../context/CrudOperationContect";

export default function DeleteDialog({ rowID }) {
  //
  const [isDeleting, setIsDeleting] = useState(false);
  const [isModalOpen, setIsModalOpen] = useState(false);
  const { deleteOperation } = useCrudOperation();

  //
  const handleDelete = async () => {
    setIsDeleting(true);
    try {
      const query = await instance.delete("settings/subjects/" + rowID);
      deleteOperation(rowID);
      toast.success("Succès", {
        description: query.data.message,
        position: "top-center",
        style: {
          backgroundColor: "#4CAF50",
          color: "white",
        },
      });
      // Ferme le modal après soumission réussie
      setIsModalOpen(false);
      setIsDeleting(false);

    } catch (error) {
      toast.success("Oops!", {
        description: error.data.message,
        position: "top-center",
        style: {
          backgroundColor: "#E11409FF",
          color: "white",
        },
      });
    }
  };

  return (
    <Dialog open={isModalOpen} onOpenChange={setIsModalOpen}>
      {/* Bouton de déclenchement du dialogue */}
      <DialogTrigger asChild>
        <Button variant="link" className="hover:cursor-pointer">
          <Trash className="text-red-600" />
        </Button>
      </DialogTrigger>
      {/* Contenu du dialogue de confirmation */}
      <DialogContent>
        <DialogHeader className="flex flex-col gap-5">
          <DialogTitle className="uppercase">
            Confirmation de suppression
          </DialogTitle>
          <DialogDescription>
            Êtes-vous sûr de vouloir supprimer cette ligne ? <br /> Cette action
            est irréversible.
          </DialogDescription>
        </DialogHeader>
        {/* Boutons d'action */}
        <DialogFooter className="mt-4">
          <DialogClose asChild>
            <Button variant="outline">Annuler</Button>
          </DialogClose>
          <Button
            variant="destructive"
            onClick={handleDelete}
            disabled={isDeleting}
          >
            {isDeleting ? "Suppression..." : "Supprimer"}
          </Button>
        </DialogFooter>
      </DialogContent>
    </Dialog>
  );
}
