"use client";

import { Button } from "../../../components/ui/button";
import { useForm } from "react-hook-form";
import { yupResolver } from "@hookform/resolvers/yup";
import * as yup from "yup";
import { Loader2 } from "lucide-react";
import { toast } from "sonner";
import instance from "../../../lib/axiosInstance";
import Link from "next/link";


const schema = yup
  .object({
    email: yup.string().required(),
    code: yup.string().required(),
    password: yup.string().required(),
    confirm_password: yup.string().required(),
  })
  .required();

export default function ForgotPassword() {
  const {
    register,
    handleSubmit,
    formState: { errors, isSubmitting },
  } = useForm({
    resolver: yupResolver(schema),
  });

  //
  const onSubmit = async (data) => {
    try {

      // Set query
      const query = await instance.post("auth/activate", data);

      // Success response
      toast.success("Compte activé", {
        description: query.data.message,
        position: "top-center",
        style: {
          backgroundColor: "#4CAF50",
          color: "white",
        },
      });
    } catch (error) {
      const response = error.data;
      toast.error(response.message, {
        description: response.response.error,
        position: "top-center",
        style: {
          backgroundColor: "#E11409FF",
          color: "white",
        },
      });
    }
  };

  return (
    <form onSubmit={handleSubmit(onSubmit)}>
      <div className="mb-12">
        <h3 className="text-black text-3xl uppercase">Activation</h3>
        <p className="text-gray-400 text-sm mt-3 leading-relaxed text-justify">
          Bienvenue ! Activez votre compte pour commencer à explorer toutes nos
          fonctionnalités. Votre voyage commence ici.
        </p>
      </div>

      <div className="relative flex items-center">
        <label
          htmlFor="email"
          className="text-gray-800 text-[13px] bg-white absolute px-2 top-[-9px] left-[18px] font-semibold"
        >
          Email
        </label>
        <input
          id="email"
          {...register("email")}
          type="email"
          placeholder="Email..."
          className="px-4 py-3.5 bg-white w-full text-sm border-2 border-gray-200 focus:border-[#fb923d] rounded-md outline-none text-black"
        />
      </div>
      <p className="text-red-500">{errors.email?.message}</p>


      <div className="relative flex items-center mt-8">
        <label
          htmlFor="code"
          className="text-gray-800 text-[13px] bg-white absolute px-2 top-[-9px] left-[18px] font-semibold"
        >
          Code d'activation
        </label>
        <input
          id="code"
          {...register("code")}
          type="text"
          placeholder="Code d'activation..."
          className="px-4 py-3.5 bg-white w-full text-sm border-2 border-gray-200 focus:border-[#fb923d] rounded-md outline-none text-black"
        />
      </div>
      <p className="text-red-500">{errors.code?.message}</p>


      <div className="relative flex items-center mt-8">
        <label
          htmlFor="password"
          className="text-gray-800 text-[13px] bg-white absolute px-2 top-[-9px] left-[18px] font-semibold"
        >
          Mot de passe
        </label>
        <input
          id="password"
          {...register("password")}
          type="password"
          placeholder="Mot de passe..."
          className="px-4 py-3.5 bg-white w-full text-sm border-2 border-gray-200 focus:border-[#fb923d] rounded-md outline-none text-black"
        />
      </div>
      <p className="text-red-500">{errors.password?.message}</p>


      <div className="relative flex items-center mt-8">
        <label
          htmlFor="cpassword"
          className="text-gray-800 text-[13px] bg-white absolute px-2 top-[-9px] left-[18px] font-semibold"
        >
          Confirmer le mot de passe
        </label>
        <input
          id="cpassword"
          {...register("confirm_password")}
          type="password"
          placeholder="Confirmer le mot de passe..."
          className="px-4 py-3.5 bg-white w-full text-sm border-2 border-gray-200 focus:border-[#fb923d] rounded-md outline-none text-black"
        />
      </div>
      <p className="text-red-500">{errors.confirm_password?.message}</p>


      <div className="mt-8">
        <Button
          type="submit"
          disabled={isSubmitting}
          className="w-full h-12 uppercase bg-[#611c14]"
        >
          {isSubmitting ? (
            <Loader2 className="animate-spin w-5 h-5 mr-2" />
          ) : (
            "Activer"
          )}
        </Button>
      </div>
    </form>
  );
}
