"use client";

import { Button } from "../../../components/ui/button";
import { useForm } from "react-hook-form";
import { yupResolver } from "@hookform/resolvers/yup";
import * as yup from "yup";
import { Loader2 } from "lucide-react";
import { toast } from "sonner";
import instance from "../../../lib/axiosInstance";
import Link from "next/link";

const schema = yup
  .object({
    email: yup.string().required(),
  })
  .required();

export default function ForgotPassword() {
  const {
    register,
    handleSubmit,
    formState: { errors, isSubmitting },
  } = useForm({
    resolver: yupResolver(schema),
  });

  //
  const onSubmit = async (data) => {
    try {
      
      // Query
      const query = await instance.post("auth/forgot-password", data);

      // Success respnse
      toast.success("Lien de réinitialisation", {
        description: query.data.message,
        position: "top-center",
        style: {
          backgroundColor: "#4CAF50",
          color: "white",
        },
      });
    } catch (error) {
      const response = error.data;
      toast.error(response.message, {
        description: response.response.error,
        position: "top-center",
        style: {
          backgroundColor: "#E11409FF",
          color: "white",
        },
      });
    }
  };
  return (
    <form onSubmit={handleSubmit(onSubmit)}>
      <div className="mb-12">
        <h3 className="text-[#611c14] text-3xl uppercase text-center">
          Mot de passe oublié
        </h3>
        <p className="text-gray-400 text-sm mt-3 leading-relaxed">
          Bienvenue ! Réinitialisez votre mot de passe pour retrouver l'accès à
          votre compte. Votre voyage continue ici.
        </p>
      </div>
      <div className="relative flex items-center">
        <label
          htmlFor="email"
          className="text-gray-800 text-[13px] bg-white absolute px-2 top-[-9px] left-[18px] font-semibold"
        >
          Email
        </label>
        <input
          id="email"
          {...register("email")}
          type="email"
          placeholder="Email..."
          className="px-4 py-3.5 bg-white w-full text-sm border-2 border-gray-200 focus:border-[#fb923d] rounded-md outline-none text-black"
        />
      </div>
      <p className="text-red-500">{errors.email?.message}</p>

      <div className="mt-8">
        <Button
          type="submit"
          disabled={isSubmitting}
          className="w-full h-12 uppercase bg-[#611c14]"
        >
          {isSubmitting ? (
            <Loader2 className="animate-spin w-5 h-5 mr-2" />
          ) : (
            "Envoyer"
          )}
        </Button>
      </div>
    </form>
  );
}
