"use client";

import { Button } from "../../components/ui/button";
import { useForm } from "react-hook-form";
import { yupResolver } from "@hookform/resolvers/yup";
import * as yup from "yup";
import { Loader2 } from "lucide-react";
import { toast } from "sonner";
import instance from "../../lib/axiosInstance";
import Link from "next/link";
import { useRouter } from "next/navigation";

const schema = yup
  .object({
    login: yup.string().required(),
    password: yup.string().required(),
  })
  .required();

export default function Login() {
  const router = useRouter();

  const {
    register,
    handleSubmit,
    formState: { errors, isSubmitting },
  } = useForm({
    resolver: yupResolver(schema),
  });

  //
  const onSubmit = async (data) => {
    try {
      // Set query
      const query = await instance.post("auth", data);
      console.log(query.data.response.token);

      // Set token key in local storage
      // Set token in HTTP-only cookie (plus sécurisé)
      document.cookie = `token=${query.data.response.token}; path=/; max-age=${
        60 * 60 * 24
      }; samesite=lax`;

      // document.cookie = `token=${query.data.response.token}; path=/; max-age=${
      //   60 * 60 * 24
      // }; secure; samesite=lax`;

      // console.log( document.cookie);
      // document.cookie = 'token=; path=/; expires=Thu, 01 Jan 1970 00:00:00 GMT; secure; samesite=lax';

      // Success response
      toast.success("Connecté", {
        description: query.data.message,
        position: "top-center",
        style: {
          backgroundColor: "#4CAF50",
          color: "white",
        },
      });

      // Redirect to dashboad
      router.push("/dashboard");
    } catch (error) {
      // console.log(error);
      const response = error.data;
      toast.error(response.message, {
        description: response.response.error,
        position: "top-center",
        style: {
          backgroundColor: "#E11409FF",
          color: "white",
        },
      });
    }
  };

  return (
    <form onSubmit={handleSubmit(onSubmit)}>
      <div className="mb-12">
        <h3 className="text-[#611c14] text-3xl uppercase text-center">
          Connexion
        </h3>
        <p className="text-gray-400 text-sm mt-3 leading-relaxed">
          Bienvenue ! Veuillez vous connecter pour accéder à votre compte et
          explorer. Votre voyage commence ici.
        </p>
      </div>
      <div className="relative flex items-center">
        <label
          htmlFor="email"
          className="text-gray-800 text-[13px] bg-white absolute px-2 top-[-9px] left-[18px] font-semibold"
        >
          Email
        </label>
        <input
          id="email"
          {...register("login")}
          type="email"
          placeholder="Email..."
          className="px-4 py-3.5 bg-white w-full text-sm border-2 border-gray-200 focus:border-[#fb923d] rounded-md outline-none text-black"
        />
      </div>
      <p className="text-red-500">{errors.login?.message}</p>

      <div className="relative flex items-center mt-8">
        <label
          htmlFor="password"
          className="text-gray-800 text-[13px] bg-white absolute px-2 top-[-9px] left-[18px] font-semibold"
        >
          Password
        </label>
        <input
          id="password"
          {...register("password")}
          type="Password"
          placeholder="Mot de passe..."
          className="px-4 py-3.5 bg-white w-full text-sm border-2 border-gray-200 focus:border-[#fb923d] rounded-md outline-none text-black"
        />
      </div>
      <p className="text-red-500">{errors.password?.message}</p>

      <div className="flex flex-wrap items-center justify-between gap-4 mt-4">
        <div className="flex items-center">
          <input
            id="remember-me"
            name="remember-me"
            type="checkbox"
            className="h-4 w-4 shrink-0 text-[#fb923d] focus:ring-[#fb923d] border-gray-300 rounded-md"
          />
          <label
            htmlFor="remember-me"
            className="ml-3 block text-sm text-[#611c14]"
          >
            Se souvenir de moi
          </label>
        </div>
        <div>
          <Link
            href="forgot-password"
            className="text-[#611c14] text-sm hover:underline"
          >
            Mot de passe publié?
          </Link>
        </div>
      </div>
      <div className="mt-8">
        <Button
          type="submit"
          disabled={isSubmitting}
          className="w-full h-12 uppercase bg-[#611c14]"
        >
          {isSubmitting ? (
            <Loader2 className="animate-spin w-5 h-5 mr-2" />
          ) : (
            " Se connecter"
          )}
        </Button>
      </div>
    </form>
  );
}
