"use client";

import { createContext, useContext } from 'react';

const ClassroomContext = createContext(null);

export function ClassroomProvider({ children, classroomID }) {
  return (
    <ClassroomContext.Provider value={classroomID}>
      {children}
    </ClassroomContext.Provider>
  );
}

export function useClassroom() {
  const classroomID = useContext(ClassroomContext);
  if (classroomID === null) {
    throw new Error('useClassroom must be used within a ClassroomProvider');
  }
  return classroomID;
}