"use client";

import { createContext, useContext } from 'react';

const PaymentsScheduleContext = createContext(null);

export function PaymentsScheduleProvider({ children, feeID }) {
  return (
    <PaymentsScheduleContext.Provider value={feeID}>
      {children}
    </PaymentsScheduleContext.Provider>
  );
}

export function usePaymentsSchedule() {
  const feeID = useContext(PaymentsScheduleContext);
  if (feeID === null) {
    throw new Error('usePaymentsSchedule must be used within a PaymentsScheduleProvider');
  }
  return feeID;
}