import { Rajdhani } from "next/font/google";
import "./globals.css";
import { Toaster } from "../components/ui/sonner";
import ProgressBarProvider from "../components/ProgressBarProvider";
const rajdhani = Rajdhani({
  subsets: ["latin"],
  weight: ["400", "500", "600", "700"], 
  variable: "--font-rajdhani",
});

export const metadata = {
  title: "MON ÉTABLISSEMENT",
};

export default function RootLayout({ children }) {
  return (
    <html>
      <body className={`${rajdhani.variable} antialiased`}>
          <ProgressBarProvider>
            {children}
            <Toaster />
          </ProgressBarProvider>
      </body>
    </html>
  );
}
