export const selectStyles = {
  control: (base, state) => ({
    ...base,
    minHeight: '48px',
    height: '48px',
    width: '100%',
    borderColor: state.isFocused ? '#dd7b34' : '#e0e0e0',
    boxShadow: state.isFocused ? '0 0 0 2px rgba(221, 123, 52, 0.2)' : 'none',
    '&:hover': {
      borderColor: state.isFocused ? '#dd7b34' : '#c0c0c0'
    }
  }),
  valueContainer: (base) => ({
    ...base,
    height: '48px',
    padding: '0 8px'
  }),
  input: (base) => ({
    ...base,
    margin: '0px',
  }),
  indicatorsContainer: (base) => ({
    ...base,
    height: '48px',
  }),
  multiValue: (base) => ({
    ...base,
    backgroundColor: '#dd7b34',
    color: 'white'
  }),
  multiValueLabel: (base) => ({
    ...base,
    color: 'white'
  }),
  multiValueRemove: (base) => ({
    ...base,
    color: 'white',
    ':hover': {
      backgroundColor: '#c56a2a',
      color: 'white'
    }
  }),
  option: (base, state) => ({
    ...base,
    backgroundColor: state.isSelected ? '#dd7b34' : state.isFocused ? '#f5e6dc' : 'white',
    color: state.isSelected ? 'white' : 'black',
    ':hover': {
      backgroundColor: state.isSelected ? '#dd7b34' : '#f5e6dc'
    }
  })
}; 