import { CiSettings } from "react-icons/ci";
import { IoIosHelpCircleOutline } from "react-icons/io";
import { BiLogOutCircle } from "react-icons/bi";
import { redirect } from 'next/navigation';


// Logout
const handleLogout = () => {
  localStorage.removeItem("token");
  sessionStorage.clear();
  redirect("/");
};



export const BottomNavBar = () => {
  return (
   <div className="bottom flex flex-col gap-2">
   <div className="flex gap-3">
     <CiSettings className="text-2xl text-white" />
     <span className="text-white">Paramètres</span>
   </div>
   <div className="flex gap-3">
     <IoIosHelpCircleOutline className="text-2xl text-white" />
     <span className="text-white">Aide</span>
   </div>
   <div className="flex gap-3">
     <BiLogOutCircle className="text-2xl text-white" />
     <span className="text-white">
       <button onClick={handleLogout}>Déconnexion</button>
     </span>
   </div>
 </div>
  )
}
