"use client";

import { User, ArrowRight, EllipsisVertical } from "lucide-react";
import Link from "next/link";
import { useRouter } from "next/navigation";
import { useAuth } from "../../app/context/AuthContext";

const Header = () => {
  const router = useRouter();
  const { user, loading } = useAuth();
  // Disconnect user
  const handleDeconnect = () => {
    document.cookie =
      "token=; path=/; expires=Thu, 01 Jan 1970 00:00:00 GMT; secure; samesite=lax";
    router.push("/");
  };

  return (
    <div className="header flex justify-between items-center shadow-2xl px-6 h-16">

      <div>lll</div>

      <div className="bg-[#000] w-96 flex flex-col gap-1 items-center justify-center rounded-b-4xl h-10 relative -top-3">
        <div className="w-20 h-1 bg-white rounded-full"></div>
        <h1 className="uppercase text-white font-medium tracking-wide">
          {user?.school?.name}
        </h1>
      </div>

      <div className="flex items-center justify-center gap-3">
        <div className="flex gap-1 items-center justify-center">
          <details className="relative ml-2">
            <summary className="cursor-pointer inline-flex items-center">
              <div className="flex items-center justify-center  border-1 h-8 w-20 border-[#601b13]">
                <h1 className="text-sm text-[#601b13] font-bold">{user?.last_name}</h1>
              </div>
              <EllipsisVertical size={18} className="text-[#601b13]"  />
            </summary>
            <div className="absolute right-0 mt-2 w-56 bg-white border rounded-md shadow-lg z-50">
              <ul className="py-1 text-sm text-gray-700">
                <li>
                  <Link
                    href="/profil"
                    className="block px-4 py-2 hover:bg-gray-100"
                  >
                    Profil
                  </Link>
                </li>
              </ul>
              <div className="">
                <button
                  onClick={handleDeconnect}
                  className="w-full bg-red-700 hover:bg-red-800 rounded-none hover:cursor-pointer py-2 text-white"
                >
                  Se déconnecter
                </button>
              </div>
            </div>
          </details>
        </div>
      </div>
      
    </div>
  );
};

export default Header;
