"use client";

import { useState } from "react";
import Link from "next/link";
import {
  NotebookText,
  LayoutDashboard,
  LineChart,
  School,
  BrickWall,
  RefreshCcwDot,
  NotebookPen,
  BookHeart,
  Calendar,
  BookOpenCheck,
  UserRound,
  User,
  BookOpen,
  Library,
  UtensilsCrossed,
  Bed,
  Users,
  Landmark,
} from "lucide-react";
import { usePathname } from "next/navigation";

// Composant pour le dropdown
const DropdownMenu = ({ label, icon: Icon, items }) => {
  const [isOpen, setIsOpen] = useState(false);
  return (
    <div className="group">
      <button
        onClick={() => setIsOpen(!isOpen)}
        className="w-full text-white hover:text-[#fb923d] transition-colors duration-200"
      >
        <div className="flex items-center justify-between">
          <div className="flex items-center gap-3 text-xl">
            <Icon className="w-6 h-6" />
            <span>{label}</span>
          </div>
          <ChevronRight
            className={`transform transition-transform duration-200 ${
              isOpen ? "rotate-90" : ""
            }`}
          />
        </div>
      </button>
      <ul
        className={`space-y-2 pl-4 mt-2 overflow-hidden transition-all duration-300 ${
          isOpen ? "max-h-48 opacity-100" : "max-h-0 opacity-0"
        }`}
      >
        {items.map((item, index) => (
          <li key={index}>
            <a
              href={item.href}
              className="text-white flex items-center gap-2 hover:text-[#fb923d] transition-colors duration-200"
            >
              {item.icon}
              <span>{item.label}</span>
            </a>
          </li>
        ))}
      </ul>
    </div>
  );
};

// Composant pour le titre de section
const SectionTitle = ({ title, isCollapsed }) => {
  if (isCollapsed) return null;
  return (
    <div className="px-3 py-2">
      <span className="text-gray-400 text-sm uppercase font-medium">
        {title}
      </span>
    </div>
  );
};

const NavBar = ({ isCollapsed }) => {
  const menuConfig = {
    sections: [
      {
        links: [
          {
            href: "#",
            icon: NotebookText,
            label: "Années scolaires",
          },
          {
            href: "/dashboard",
            icon: LayoutDashboard,
            label: "Tableau de bord",
          },
          {
            href: "#",
            icon: LineChart,
            label: "Reportings",
          },
        ],
      },

      {
        title: "VIE SCOLAIRE",
        links: [
          {
            href: "/schoollife/exams",
            icon: School,
            label: "Examens et contrôles de niveau",
          },
          {
            href: "/schoollife/classrooms",
            icon: School,
            label: "Classes",
          },
          {
            href: "/schoollife/subjects",
            icon: BrickWall,
            label: "Matières",
          },
          {
            href: "/schoollife/levels",
            icon: BrickWall,
            label: "Niveaux",
          },
          {
            href: "/schoollife/plans",
            icon: RefreshCcwDot,
            label: "Plans de cours",
          },
          // {
          //   href: "/schoollife/exams-controls",
          //   icon: NotebookPen,
          //   label: "Examens et contrôles de niveau",
          // },
          {
            href: "/schoollife/appreciation",
            icon: BookHeart,
            label: "Appréciations",
          },
          {
            href: "#",
            icon: Calendar,
            label: "Activités scolaires",
          },
          {
            href: "#",
            icon: BookOpenCheck,
            label: "Courriers",
          },
        ],
      },

      {
        title: "COMPTABILITÉ",
        links: [
          {
            href: "/accounting/fees",
            icon: Landmark,
            label: "Frais scolaires",
          },
          {
            href: "#",
            icon: Users,
            label: "Inscriptions",
          },
          {
            href: "/accounting/fee-types",
            icon: BookOpen,
            label: "Type de frais",
          },
        ],
      },

      {
        title: "PERSONNEL",
        links: [
          {
            href: "/personnels/school-resources",
            icon: UserRound,
            label: "Personnel administratif",
          },
          {
            href: "/personnels/teachers",
            icon: User,
            label: "Enseignants",
          },
          {
            href: "/personnels/educators",
            icon: User,
            label: "Éducateurs",
          },
          {
            href: "/personnels/students",
            icon: User,
            label: "Élèves",
          },
          {
            href: "/personnels/others",
            icon: Users,
            label: "Autres",
          },
        ],
      },

      {
        title: "PARASCOLAIRE",
        links: [
          {
            href: "/paraschool/library",
            icon: Library,
            label: "Bibliothèque",
          },
          {
            href: "/paraschool/lunchroom",
            icon: UtensilsCrossed,
            label: "Cantine",
          },
          {
            href: "/paraschool/boarding",
            icon: Bed,
            label: "Internat",
          },
          {
            href: "/paraschool/clubs",
            icon: Users,
            label: "Clubs",
          },
        ],
      },
    ],
  };

  return (
    <nav
      // className={`transition-all duration-300 ${isCollapsed ? "w-12" : "w-64"}`}
      className={`transition-all duration-300`}
    >
      <ul className="space-y-4">
        {menuConfig.sections.map((section, sectionIndex) => (
          <li key={sectionIndex} className="space-y-3">
            <SectionTitle title={section.title} isCollapsed={isCollapsed} />
            {section.links?.map((link, index) => (
              <NavLink key={index} {...link} isCollapsed={isCollapsed} />
            ))}
            {!isCollapsed &&
              section.dropdowns?.map((dropdown, index) => (
                <DropdownMenu
                  key={index}
                  label={dropdown.label}
                  icon={dropdown.icon}
                  items={dropdown.items}
                />
              ))}
          </li>
        ))}
      </ul>
    </nav>
  );
};

const NavLink = ({ href, icon: Icon, label, isCollapsed }) => {
  const pathname = usePathname();
  const isActive = pathname.includes(href); // Si le href est dans le pathname
  return (
    <div>
      <Link
        href={href}
        className={`flex items-center gap-3 text-md transition-colors duration-200
          ${isCollapsed ? "justify-center" : ""}
          ${isActive ? "text-[#fb923d]" : "text-white hover:text-[#fb923d]"}`}
      >
        <Icon className={`w-5 h-5 ${isActive ? "text-[#fb923d]" : ""}`} />
        {!isCollapsed && <span>{label}</span>}
      </Link>
    </div>
  );
};
export default NavBar;
