// lib/auth.js
export async function verifyToken(token) {
   try {
      const response = await fetch('https://v1-api-xselschool.xsel-ci.com/v1/classrooms', {
         method: 'POST',
         headers: {
            'Content-Type': 'application/json',
            'Authorization': `Bearer ${token}`
         }
      })

      if (!response.ok) {
         console.log(response);
         return false
      }

      const data = await response.json()
      return data.valid
   } catch (error) {
      console.error('Erreur de vérification du token:', error)
      return false
   }
}