import axios from "axios";
// import { cookies } from 'next/headers'; // For server components


// Axios Interceptor Instance
const instance = axios.create({
  baseURL: "https://v1-api-xselschool.xsel-ci.com/v1/"
});

// Conditionnellement ajouter l'intercepteur seulement côté client
if (typeof window !== 'undefined') {
  // const token = document.cookie.split('; ').find(row => row.startsWith('token='))?.split('=')[1];
  // const accessToken = token ? token : null;
  instance.interceptors.request.use(
    (config) => {
      // const token = "";
      // const token = request.cookies.get('token')?.value
      const token = document.cookie.split('; ').find(row => row.startsWith('token='))?.split('=')[1];
      const accessToken = token ? token : null;
      // console.log('accessToken');
      // If token is present, add it to request's Authorization Header
      if (accessToken) {
        // It's a good practice to use the 'Authorization' header as per the HTTP standard
        config.headers['Authorization'] = `Bearer ${accessToken}`;
      }

      return config;
    },
    (error) => {
      // Handle request errors here
      return Promise.reject(error);
    }
  );
}



// Axios Interceptor: Response Method
instance.interceptors.response.use(
  (response) => {
    // Can be modified response if needed
    return response;
  },
  (error) => {
    // console.log(error.response);
    // Handle response errors here, e.g., checking error codes like 401, 500, etc.
    if (error.response && error.response.status === 401) {
      // You can log out the user or redirect to login page for unauthorized requests
      console.log('Unauthorized access.');
      // const router = useRouter();
      // router.push("/");
      // return NextResponse.redirect('/')
    }

    return Promise.reject(error.response);
  }
);

export default instance;
