import { NextResponse } from 'next/server'

// Chemins protégés - nécessitent un token
const PROTECTED_PATHS = [
  '/profile',
  '/dashboard',
  '/schoollife',
  '/accounting',
  '/personnels',
  '/paraschool'
]

export function middleware(request) {
  const { pathname } = request.nextUrl
  const token = request.cookies.get('token')?.value

  // Vérifie si le chemin actuel est protégé
  const isProtectedPath = PROTECTED_PATHS.some(path => 
    pathname.startsWith(path)
  )

  // Utilisateur connecté (avec token)
  if (token) {
    // Redirige de la page d'accueil vers le dashboard si déjà connecté
    if (pathname === '/') {
      return NextResponse.redirect(new URL('/dashboard', request.url))
    }
    
    // Autorise l'accès aux autres pages
    return NextResponse.next()
  }
  // Utilisateur non connecté
  else {
    // Redirige vers la page de login si tente d'accéder à une page protégée
    if (isProtectedPath) {
      return NextResponse.redirect(new URL('/', request.url))
    }
    
    // Autorise l'accès aux pages publiques
    return NextResponse.next()
  }
}

export const config = {
  matcher: [
    '/',
    '/profile',
    '/dashboard/:path*',
    '/schoollife/:path*',
    '/accounting/:path*',
    '/personnels/:path*',
    '/paraschool/:path*',
  ]
}